using System;
using System.Runtime.InteropServices;
using System.Threading;


namespace Shared
{
	/// <summary>
	/// ImportComiMotionDLL   Դϴ.
    ///  : 2011.05.03
	/// </summary>
    public unsafe class ComiDasLX
    {
        public struct ScanData
        {
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 1024)]
            public double[] fData;
        }

        // Device ID definition // 
        public const int COMI_LX101	= 0xA101 ;
        public const int COMI_LX102	= 0xA102 ;
        public const int COMI_LX103	= 0xA103 ;
        public const int COMI_LX201	= 0xA201 ;
        public const int COMI_LX202	= 0xA202 ;
        public const int COMI_LX203	= 0xA203 ;
        public const int COMI_LX211	= 0xA211 ;
        public const int COMI_LX212	= 0xA212 ;
        public const int COMI_LX301	= 0xA301 ;
        public const int COMI_LX401	= 0xA401 ;
        public const int COMI_LX402	= 0xA402 ;
        public const int COMI_LX501	= 0xA501 ;
        public const int COMI_LX502	= 0xA502 ;
        public const int COMI_LX504	= 0xA504 ;
        public const int COMI_LX508	= 0xA508 ;
        public const int COMI_LX534	= 0xA534 ;
        public const int COMI_LX544	= 0xA544 ;

        /* Define scan method */
        public const int TRS_SINGLE 	=	0x1 ;
        public const int TRS_BLOCK		=0x2    ;
        public const int TRS_BLOCK_EXT	=0x3    ;

        /* Define DIO Usage - only for COMI_CP_401 Board */
        public const int DI_ONLY =		0 ;
        public const int DO_DI	 =	1     ;
        public const int DI_DO	 =	2     ;
        public const int DO_ONLY =		3 ;

        /* define counter control values */
        public const int   COUNTER_LATCH    =  0 ; /* counter latch operation       */
        public const int   READ_LOAD_MSB    =  1 ; /* read/load MSB only            */
        public const int   READ_LOAD_LSB    =  2 ; /* read/load LSB only            */
        public const int   READ_LOAD_WORD   =  3 ; /* read/load LSB first, then MSB */

        public const int   BCD           =     1 ; /* BCD counter                */
        public const int   BINARY        =     0 ; /* Binary counter             */
                                         
        public const int   CMODE0        =     0 ; /* Interrupt on terminal count   */
        public const int   CMODE1        =     1 ; /* Programmable one shot         */
        public const int   CMODE2        =     2 ; /* Rate generator                */
        public const int   CMODE3        =     3 ; /* Square wave rate generator    */
        public const int   CMODE4        =     4 ; /* Software triggered strobe     */
        public const int   CMODE5        =     5 ; /* Hardware triggered strobe     */

        /* Encoder Counter mode */
        public const int ENCODER_1X	= 0  ;   /* 1ä ڴ  */
        public const int ENCODER_2X	= 1	 ; /* 2ä ڴ  */
        public const int ENCODER_4X	= 2	 ; /* 4ä ڴ  */

        public const int PG_INFINITE	= 0 ; /* PULSE GEN. Infinite mode */

        public const int AI_SINGLE =1 ;  /* Single Ended input */
        public const int AI_DIFF	=	0 ; /* Differential input */

        public const int TS_NONE = 0 ;
        public const int TS_ANALOG = 1 ;
        public const int TS_DIGITAL = 2 ;
        public const int TE_POSITIVE = 0 ;
        public const int TE_NEGATIVE = 1 ;
        public const int TM_INITIAL = 0 ;
        public const int TM_MIDDLE = 1 ;

        //----- Definitions for Motion -------------------------------------------//
        public const uint CMC_LIN_MODE1	= 0x00000000; // Linear interpolation mode 1 (4ຸ )
        public const uint CMC_LIN_MODE2 = 0x80000000; // Linear interpolation mode 2 (8ຸ , ÿ    )
        public const int MAX_CmpTrgIx_MAP_ID	=	3;	// 2  ġ  ִ밪(0 ~ 3)


        
        //************* Error codes *************************************//
        public const int ERR_INVALID_DEVICE_HANDLE	= -270 ; // Invalid device handle is passed to a function
        public const int ERR_INVALID_FILE_PATH		= -280 ; 
        public const int ERR_MEM_ALLOC_FAIL			= -290 ; // Memory allocation fail
        public const int ERR_FILE_OPEN_FAIL			= -300 ; // File open fail
        public const int ERR_FILE_CREATE_FAIL		= -301 ; // File creation fail
        public const int ERR_ISR_CONNEC_FAIL		= 	-310 ; // ISR registration fail
        public const int ERR_DIVIDE_BY_ZERO			= -400 ; // Cause divide by zero error 
        public const int ERR_WORNG_NUM_DATA			= -500 ; // Number of data is too small or too big
        public const int ERR_VER_MISMATCH			= -600 ; // Version is not matched
        public const int ERR_MC_BASE				= 	-3000 ; // Base error code value for motion errors
        public const int ERR_MC_COMP_FILE_OPEN_FAIL	= (ERR_MC_BASE-1) ;		// position compensation table file open fail!
        public const int ERR_CMPIX_INVALID_MAP		= -5180 ; // Interpolated position compare output map is not valid
        public const int ERR_CMPIX_INVALID_AXIS		= -5182 ; // Axis setting is not valid for the specified interpolated position compare output map.
        public const int ERR_CMPIX_INVALID_DO_CHAN	= -5184 ; // D/O channel setting is not valid for the specified interpolated position compare output map.
        public const int ERR_CMPIX_ALREADY_ACTIVE	= -5186 ; // Specified Interpolated position compare output map is already active.
        public const int ERR_CMPIX_TABLE_EMPTY		= -5188 ; // Interpolated position compare output table data is empty.


		 public enum TComiVarType
		{
			 VT_SHORT, VT_FLOAT, VT_DOUBLE
		}

		 public struct TComiDevInfo
		{
			public int	wSubSysID;
			public int	nInstance;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 20)]
			public String  szDevName;
			public char	bDevCaps; // 0bit-A/D, 1bit-D/A, 2bit-DIO, 3bit-Counter,
			public char	nNumAdChan, nNumDaChan, nNumDiChan, nNumDoChan, nNumCntrChan;
		}

		public struct TComiDevList{
			public int nNumDev;
            [MarshalAs(UnmanagedType.Struct, SizeConst = 16)]
			public TComiDevInfo[] DevInfo;
		}

		public struct TScanFileHead
		{
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 13)]
			public String szDate;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 10)]
            public String szTime;  // Save start ¥ ð  Ʈ
			public int nNumChan; // Scan ä 
            [MarshalAs(UnmanagedType.I4, SizeConst = 64)]
			public int[] nChanList; // Scan ä Ʈ
			public int dmin, dmax;

            [MarshalAs(UnmanagedType.I4, SizeConst = 64)]
			public float[] vmin;

            [MarshalAs(UnmanagedType.I4, SizeConst = 64)]
            public float[] vmax; // Scan  ä A/D range

            public int dwSavedScanCnt; //   Scan 
		}

		public struct TPidParams
		{
			public float Ref, lim_h, lim_l;
            public float Kp;
            public float Td, Ti;
            public int ch_ref, ch_ad, ch_da;
		}

		public struct THelicalUserInfo{
			public int c_map, z_axis; // Circualr interpolation axis map, Up/Down Axis
			public double c_xcen, c_ycen; // Circular interpolation ceneter point
			public int c_dir; // ȣ ȸ 
			public int c_num; //  (ڸ Arc )
			public double c_la; // Last angle
			public double z_dist;
		}


        public delegate void CallbackFunc(IntPtr lParam);

        //====================== General FUNCTIONS ====================================================//
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_LoadDevice")]
        public static extern unsafe IntPtr COMILX_LoadDevice([MarshalAs(UnmanagedType.I4)] int deviceID, [MarshalAs(UnmanagedType.I4)] int instance);
        
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_UnloadDevice")]
        public static extern unsafe void COMILX_UnloadDevice(IntPtr hDevice);
        
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_SetComiBus")]
        public static extern unsafe void COMILX_SetComiBus(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int bEnable, [MarshalAs(UnmanagedType.I4)] int bIsMaster);

		//___________ General A/D Functions _____________________________________________//

        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_AD_SetInputType")]
        public static extern unsafe void COMILX_AD_SetInputType(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nInputMode);
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_AD_SetRange")]
        public static extern unsafe int COMILX_AD_SetRange(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch, [MarshalAs(UnmanagedType.R4)] float vmin, [MarshalAs(UnmanagedType.R4)] float vmax);
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_AD_GetDigit")]
        public static extern unsafe int COMILX_AD_GetDigit(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch ) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_AD_GetVolt")]
        public static extern unsafe double COMILX_AD_GetVolt(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch ) ;

		 //___________ Unlimited A/D Scan for LX10x _____________________________________________//


		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US1_Start")]
        public static extern unsafe int COMILX_US1_Start(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nNumChannel, int[] ChanList,
			[MarshalAs(UnmanagedType.I4)] int dwScanFreq, [MarshalAs(UnmanagedType.I4)] int nBufSize, [MarshalAs(UnmanagedType.I4)] int nTrsMethod) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US1_Stop")]
        public static extern unsafe void COMILX_US1_Stop(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int bReleaseBuf ) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US1_ChangeScanFreq")]
        public static extern unsafe int COMILX_US1_ChangeScanFreq(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int dwScanFreq ) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US1_ResetCount")]
        public static extern unsafe void COMILX_US1_ResetCount(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US1_GetBuffer")]
        public static extern unsafe short* COMILX_US1_GetBuffer(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US1_CurCount")]
        public static extern unsafe int COMILX_US1_CurCount(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US1_SBPos")]
        public static extern unsafe uint COMILX_US1_SBPos(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int chOrder, [MarshalAs(UnmanagedType.R8)] double scanCount) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US1_ReleaseBuf")]
        public static extern unsafe bool COMILX_US1_ReleaseBuf(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US1_RetrvOne")]
        public static extern unsafe float COMILX_US1_RetrvOne(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int chOrder, [MarshalAs(UnmanagedType.R8)] double scanCount) ;

        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US1_RetrvChannel")]
        public static extern unsafe int COMILX_US1_RetrvChannel(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int chOrder, [MarshalAs(UnmanagedType.I4)] int startCount,
            [MarshalAs(UnmanagedType.I4)] int maxNumData, IntPtr Buffer, [MarshalAs(UnmanagedType.I4)] int VarType) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US1_RetrvBlock")]
        public static extern unsafe int COMILX_US1_RetrvBlock(IntPtr hDevice, [MarshalAs(UnmanagedType.R8)] double StartCount, [MarshalAs(UnmanagedType.I4)] int maxNumScan, 
			IntPtr pDestBuf, TComiVarType VarType) ;

		 //___________ Unlimited A/D Scan for LX20x _____________________________________________//

		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US2_SetTriggerEvent")]
        public static extern unsafe void COMILX_US2_SetTriggerEvent(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nInputSource, [MarshalAs(UnmanagedType.I4)] int nEdgeType, 
			[MarshalAs(UnmanagedType.I4)] int nTrgMode, [MarshalAs(UnmanagedType.R8)] double fAiRef, [MarshalAs(UnmanagedType.R8)] double fAiRefBand) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US2_Start")]
        public static extern unsafe double COMILX_US2_Start(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nNumChannel, int[] pChanList, 
			[MarshalAs(UnmanagedType.I4)] int nScanFreq, [MarshalAs(UnmanagedType.I4)] int nBufSizeGain, bool bPauseAtBufFull) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US2_Resume")]
        public static extern unsafe void COMILX_US2_Resume(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US2_ChangeScanFreq")]
        public static extern unsafe double COMILX_US2_ChangeScanFreq(IntPtr hDevice, [MarshalAs(UnmanagedType.R8)] double dwScanFreq) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US2_DmaCount")]
        public static extern unsafe int COMILX_US2_DmaCount(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US2_IsBufFull")]
        public static extern unsafe int COMILX_US2_IsBufFull(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US2_GetBuffer")]
        public static extern unsafe short* COMILX_US2_GetBuffer(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int chOrder) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US2_RetrvChannel")]
        public static extern unsafe int COMILX_US2_RetrvChannel(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int chOrder, [MarshalAs(UnmanagedType.I4)] int startCount, [MarshalAs(UnmanagedType.I4)] int maxNumData,
             IntPtr pDestBuf, TComiVarType VarType);
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US2_Stop")]
        public static extern unsafe double COMILX_US2_Stop(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int bReleaseBuf) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_US2_ReleaseBuf")]
        public static extern unsafe double COMILX_US2_ReleaseBuf(IntPtr hDevice) ;

		 //___________ DIO Common __________________________________________________//

		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_DIO_SetUsage")]
        public static extern unsafe void COMILX_DIO_SetUsage(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int usage) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_DIO_GetUsage")]
        public static extern unsafe int COMILX_DIO_GetUsage(IntPtr hDevice) ;


		//__________ D/I Functions ________________________________________________//

		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_DI_GetOne")]
        public static extern unsafe int COMILX_DI_GetOne(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_DI_GetAll")]
        public static extern unsafe int COMILX_DI_GetAll(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_DI_GetAllEx")]
        public static extern unsafe int COMILX_DI_GetAllEx(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nGroupIdx) ;

		 //__________ D/O Functions ________________________________________________//

		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_DO_PutOne")]
        public static extern unsafe void COMILX_DO_PutOne(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch, [MarshalAs(UnmanagedType.I4)] int status) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_DO_PutAll")]
        public static extern unsafe void COMILX_DO_PutAll(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int  dwStatuses) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_DO_PutAllEx")]
        public static extern unsafe void COMILX_DO_PutAllEx(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nGroupIdx, [MarshalAs(UnmanagedType.I4)] int  dwStatuses) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_DO_GetOne")]
        public static extern unsafe int COMILX_DO_GetOne(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_DO_GetAll")]
        public static extern unsafe int COMILX_DO_GetAll(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_DO_GetAllEx")]
        public static extern unsafe int COMILX_DO_GetAllEx(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nGroupIdx) ;

		//__________ Serial Digital Input/Output Functions ________________________//
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_SDIO_InitComm")]
        public static extern unsafe int COMILX_SDIO_InitComm(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_SDIO_CheckModule")]
        public static extern unsafe int COMILX_SDIO_CheckModule(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nModuleNo) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_SDIO_SetDioUsage")]
        public static extern unsafe int COMILX_SDIO_SetDioUsage(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nModuleNo, [MarshalAs(UnmanagedType.I4)] int uSage) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_SDIO_ReadLowByte")]
        public static extern unsafe int COMILX_SDIO_ReadLowByte(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nModuleNo) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_SDIO_ReadHighByte")]
        public static extern unsafe int COMILX_SDIO_ReadHighByte(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nModuleNo) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_SDIO_ReadWord")]
        public static extern unsafe int COMILX_SDIO_ReadWord(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nModuleNo) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_SDIO_WriteLowByte")]
        public static extern unsafe int COMILX_SDIO_WriteLowByte(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nModuleNo, [MarshalAs(UnmanagedType.I4)] int bValue) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_SDIO_WriteHighByte")]
        public static extern unsafe int COMILX_SDIO_WriteHighByte(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nModuleNo, [MarshalAs(UnmanagedType.I4)] int bValue) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_SDIO_WriteWord")]
        public static extern unsafe int COMILX_SDIO_WriteWord(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nModuleNo, [MarshalAs(UnmanagedType.I4)] int wWord) ;

		 //__________ D/A Functions ________________________________________________//

		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_DA_Out")]
        public static extern unsafe int COMILX_DA_Out(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch, [MarshalAs(UnmanagedType.R8)] double volt) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_WFM_Start")]
        public static extern unsafe double COMILX_WFM_Start(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch, ref double pDataBuffer, [MarshalAs(UnmanagedType.R8)] double nNumData, 
			 [MarshalAs(UnmanagedType.R8)] double nPPS, [MarshalAs(UnmanagedType.I4)] int nMaxLoops) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_WFM_Reload")]
        public static extern unsafe int COMILX_WFM_Reload(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch, ref double pDataBuffer, [MarshalAs(UnmanagedType.R8)] double nNumData) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_WFM_RateChange")]
        public static extern unsafe double COMILX_WFM_RateChange(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch, [MarshalAs(UnmanagedType.R8)] double nPPS) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_WFM_GetCurPos")]
        public static extern unsafe double COMILX_WFM_GetCurPos(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_WFM_GetCurLoops")]
        public static extern unsafe long COMILX_WFM_GetCurLoops(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_WFM_Stop")]
        public static extern unsafe void COMILX_WFM_Stop(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch) ;

		  //__________ Counter Functions ____________________________________________//

		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_ReadCounter32")]
        public static extern unsafe double COMILX_ReadCounter32(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_ClearCounter32")]
        public static extern unsafe void COMILX_ClearCounter32(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch) ;

		 //__________ Motion/Control Functions ____________________________________________//
		 // Initialize functions //

		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_Reset")]
        public static extern unsafe void COMILX_MC_Reset(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_ServoOn")]
        public static extern unsafe void COMILX_MC_ServoOn(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int bEnable) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetServoOn")]
        public static extern unsafe int COMILX_MC_GetServoOn(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetBlockingMode")]
        public static extern unsafe void COMILX_MC_SetBlockingMode(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int bBlocking) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetWindowHandle")]
        public static extern unsafe void COMILX_MC_SetWindowHandle(IntPtr hDevice, [MarshalAs(UnmanagedType.R8)] double hWnd) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetOutputMode")]
        public static extern unsafe void COMILX_MC_SetOutputMode(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel,[MarshalAs(UnmanagedType.I4)] int nOutputMode) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetOutputMode")]
        public static extern unsafe int COMILX_MC_GetOutputMode(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetInputMode")]
        public static extern unsafe void COMILX_MC_SetInputMode(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nInputMode, [MarshalAs(UnmanagedType.I4)] int nPulseLogic) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetInputMode")]
        public static extern unsafe void COMILX_MC_GetInputMode(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref int pInputMode, ref int pPulseLogic) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetSpeedRange")]
        public static extern unsafe void COMILX_MC_SetSpeedRange(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fMaxSpeed) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetSpeedRange")]
        public static extern unsafe void COMILX_MC_GetSpeedRange(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref double fMinSpeed, ref double fMaxSpeed) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetUnitDistance")]
        public static extern unsafe void COMILX_MC_SetUnitDistance(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fUnitDist) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetUnitDistance")]
        public static extern unsafe double COMILX_MC_GetUnitDistance(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetUnitSpeed")]
        public static extern unsafe void COMILX_MC_SetUnitSpeed(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fUnitSpeed) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetUnitSpeed")]
        public static extern unsafe double COMILX_MC_GetUnitSpeed(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;		
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetInOutRatio")]
        public static extern unsafe void COMILX_MC_SetInOutRatio(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fRatio) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetPosSrc")]
        public static extern unsafe void COMILX_MC_SetPosSrc(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nSource) ;


		  // Single Axis Motions //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetSpeedMode")]
        public static extern unsafe void COMILX_MC_SetSpeedMode(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nModeIndex) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetSpeed")]
        public static extern unsafe void COMILX_MC_SetSpeed(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fInitSpeed, [MarshalAs(UnmanagedType.R8)] double fWorkSpeed) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetAccel")]
        public static extern unsafe void COMILX_MC_SetAccel(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fAccel, [MarshalAs(UnmanagedType.R8)] double fDecel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetScurve")]
        public static extern unsafe void COMILX_MC_SetScurve(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fSVacc, [MarshalAs(UnmanagedType.R8)] double fSVdec) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartVMove")]
        public static extern unsafe void COMILX_MC_StartVMove(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nDirection) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartMove")]
        public static extern unsafe void COMILX_MC_StartMove(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fDistance) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_Move")]
        public static extern unsafe void COMILX_MC_Move(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fDistance) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartMoveTo")]
        public static extern unsafe void COMILX_MC_StartMoveTo(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fPositon) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_MoveTo")]
        public static extern unsafe void COMILX_MC_MoveTo(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fPosition) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_Stop")]
        public static extern unsafe void COMILX_MC_Stop(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_EmgStop")]
        public static extern unsafe void COMILX_MC_EmgStop(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_Done")]
        public static extern unsafe int COMILX_MC_Done(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;

		   // Multi-Axes Motion //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartVMoveAll")]
        public static extern unsafe void COMILX_MC_StartVMoveAll(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nNumAxis, ref int nAxisList, ref int nDirList) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartMoveAll")]
        public static extern unsafe void COMILX_MC_StartMoveAll(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nNumAxis, ref int nAxisList, ref double fDistList) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_MoveAll")]
        public static extern unsafe void COMILX_MC_MoveAll(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nNumAxis, ref int nAxisList, ref double fDistList) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartMoveToAll")]
        public static extern unsafe void COMILX_MC_StartMoveToAll(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nNumAxis, ref int nAxisList, ref double fPosList) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_MoveToAll")]
        public static extern unsafe void COMILX_MC_MoveToAll(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nNumAxis, ref int nAxisList, ref double fPosList) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StopAll")]
		public static extern unsafe void COMILX_MC_StopAll(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nNumAxis, ref int nAxisList) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_EmgStopAll")]
        public static extern unsafe void COMILX_MC_EmgStopAll(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nNumAxis, ref int nAxisList) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_AllDone")]
        public static extern unsafe int COMILX_MC_AllDone(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nNumAxis, ref int nAxisList) ;


		 // Coordinated Motion //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_MapAxes")]
        public static extern unsafe int COMILX_MC_MapAxes(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, [MarshalAs(UnmanagedType.R8)] double bMapMask) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetSpeedModeMx")]
        public static extern unsafe void COMILX_MC_SetSpeedModeMx(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, [MarshalAs(UnmanagedType.I4)] int nModeIndex) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetSpeedMx")]
        public static extern unsafe void COMILX_MC_SetSpeedMx(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, [MarshalAs(UnmanagedType.R8)] double fSpeed, [MarshalAs(UnmanagedType.R8)] double fAccel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartLine")]
        public static extern unsafe void COMILX_MC_StartLine(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, ref double fDistList) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_Line")]
        public static extern unsafe void COMILX_MC_Line(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, ref double fDistList) ;  
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartLineTo")]
        public static extern unsafe void COMILX_MC_StartLineTo(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, ref double fPosList) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_LineTo")]
        public static extern unsafe void COMILX_MC_LineTo(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, ref double fPosList) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartArc_a")]
        public static extern unsafe void COMILX_MC_StartArc_a(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, [MarshalAs(UnmanagedType.R8)] double fXCentOffset, [MarshalAs(UnmanagedType.R8)] double fYCnetOfferset, 
		[MarshalAs(UnmanagedType.R8)] double fEndAngle) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_Arc_a")]
        public static extern unsafe void COMILX_MC_Arc_a(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, [MarshalAs(UnmanagedType.R8)] double fXCnetOfferset, [MarshalAs(UnmanagedType.R8)] double fYCentOfferset, 
		[MarshalAs(UnmanagedType.R8)] double fEndAngle) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartArc_p")]
        public static extern unsafe void COMILX_MC_StartArc_p(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, [MarshalAs(UnmanagedType.R8)] double fXCnetOffset, [MarshalAs(UnmanagedType.R8)] double fYCentOffset, 
		[MarshalAs(UnmanagedType.R8)] double fXEndPointDsit, [MarshalAs(UnmanagedType.R8)] double fYEndPointDist, [MarshalAs(UnmanagedType.I4)] int nDir) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_Arc_p")]
        public static extern unsafe void COMILX_MC_Arc_p(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, [MarshalAs(UnmanagedType.R8)] double fXCentOffset, [MarshalAs(UnmanagedType.R8)] double fYCnetOfferset, 
		[MarshalAs(UnmanagedType.R8)] double fXEndPointDsit, [MarshalAs(UnmanagedType.R8)] double fYEndPointDist, [MarshalAs(UnmanagedType.I4)] int nDir) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartArcTo_a")]
        public static extern unsafe void COMILX_MC_StartArcTo_a(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, [MarshalAs(UnmanagedType.R8)] double fXCent, [MarshalAs(UnmanagedType.R8)] double fYCent, 
		[MarshalAs(UnmanagedType.R8)] double fEndAngle) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_ArcTo_a")]
        public static extern unsafe void COMILX_MC_ArcTo_a(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, [MarshalAs(UnmanagedType.R8)] double fXCent, [MarshalAs(UnmanagedType.R8)] double fYCent, 
		[MarshalAs(UnmanagedType.R8)] double fEndAngle) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartArcTo_p")]
        public static extern unsafe void COMILX_MC_StartArcTo_p(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, [MarshalAs(UnmanagedType.R8)] double fXCent, [MarshalAs(UnmanagedType.R8)] double fYCent, 
		[MarshalAs(UnmanagedType.R8)] double fXEndPos, 		[MarshalAs(UnmanagedType.R8)] double fYEndPos, 		[MarshalAs(UnmanagedType.I4)] int nDir) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_ArcTo_p")]
        public static extern unsafe void COMILX_MC_ArcTo_p(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, [MarshalAs(UnmanagedType.R8)] double fXCent, [MarshalAs(UnmanagedType.R8)] double fYCent, 
		[MarshalAs(UnmanagedType.R8)] double fXEndPos, [MarshalAs(UnmanagedType.R8)] double fYEndPos, [MarshalAs(UnmanagedType.I4)] int nDir) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_CompleteArc")]
        public static extern unsafe void COMILX_MC_CompleteArc(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_MxDone")]
        public static extern unsafe int COMILX_MC_MxDone(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex) ;

		 // Spline Interpolation //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_BuildSpline")]
        public static extern unsafe double COMILX_MC_BuildSpline(ref double fInPoints, [MarshalAs(UnmanagedType.I4)] int nNumInPoints, [MarshalAs(UnmanagedType.I4)] int nNumOutPoints) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_DeleteSpline")]
        public static extern unsafe void COMILX_MC_DeleteSpline(ref double pSplineBuffer) ;

		  // Helical Interpolation //
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartHelical")]
        public static extern unsafe int COMILX_MC_StartHelical(IntPtr hDevice, ref THelicalUserInfo pHelicalUserInfo) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_AbortHelical")]
        public static extern unsafe int COMILX_MC_AbortHelical(IntPtr hDevice) ;


		 // Overriding //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_OverrideSpeedSet")]
        public static extern unsafe void COMILX_MC_OverrideSpeedSet(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_OverrideSpeedSetAll")]
        public static extern unsafe void COMILX_MC_OverrideSpeedSetAll(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nNumAxis, ref int nAxisList) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_OverrideMove")]
        public static extern unsafe int COMILX_MC_OverrideMove(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fNewDistance) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_OverrideMoveTo")]
        public static extern unsafe int COMILX_MC_OverrideMoveTo(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fNewPosition) ;


		 // Home Move //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetHomeConfig")]
        public static extern unsafe void COMILX_MC_SetHomeConfig(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nOrgLogic, [MarshalAs(UnmanagedType.I4)] int nEzCount, 
			 [MarshalAs(UnmanagedType.I4)] int nEzLogic, [MarshalAs(UnmanagedType.I4)] int nErcOut) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_HomeMove")]
        public static extern unsafe void COMILX_MC_HomeMove(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nDirection, [MarshalAs(UnmanagedType.R8)] double fRvsVel) ;


		 // External Switch Move //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartVMoveEx")]
        public static extern unsafe void COMILX_MC_StartVMoveEx(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartMoveEx")]
        public static extern unsafe void COMILX_MC_StartMoveEx(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nDirection, [MarshalAs(UnmanagedType.R8)] double fDistance) ;



		 // Pulser Mode //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetPulserInputMode")]
        public static extern unsafe void COMILX_MC_SetPulserInputMode(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nInputMode, [MarshalAs(UnmanagedType.I4)] int bInverse) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_PulserHomeMove")]
        public static extern unsafe void COMILX_MC_PulserHomeMove(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nHomeType) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartPulserVMove")]
        public static extern unsafe void COMILX_MC_StartPulserVMove(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartPulserMove")]
        public static extern unsafe void COMILX_MC_StartPulserMove(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fDistance) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_PulserMove")]
        public static extern unsafe void COMILX_MC_PulserMove(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fDistance) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartPulserMoveTo")]
        public static extern unsafe void COMILX_MC_StartPulserMoveTo(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fPosition) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_PulserMoveTo")]
        public static extern unsafe void COMILX_MC_PulserMoveTo(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fPosition) ;


		 // List-Motion //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetListMotionAxes")]
        public static extern unsafe void COMILX_MC_SetListMotionAxes(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int bMapMask) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_BeginList")]
        public static extern unsafe void COMILX_MC_BeginList(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_EndList")]
        public static extern unsafe void COMILX_MC_EndList(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartListMotion")]
        public static extern unsafe void COMILX_MC_StartListMotion(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_AbortListMotion")]
        public static extern unsafe void COMILX_MC_AbortListMotion(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_CheckListMotionDone")]
        public static extern unsafe int COMILX_MC_CheckListMotionDone(IntPtr hDevice) ;

		 // Reset //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_ResetAxis")]
        public static extern unsafe void COMILX_MC_ResetAxis(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;


		 // Get/Set Status //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetCurSpeed")]
        public static extern unsafe double COMILX_MC_GetCurSpeed(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_EnableActSpdChk")]
        public static extern unsafe void COMILX_MC_EnableActSpdChk(IntPtr hDevice, [MarshalAs(UnmanagedType.R8)] double dwInterval) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_DisableActSpdChk")]
        public static extern unsafe void COMILX_MC_DisableActSpdChk(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetActualSpeed")]
        public static extern unsafe double COMILX_MC_GetActualSpeed(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
    	
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetPosition_A")]
        public static extern unsafe double COMILX_MC_GetPosition_A(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetPosition_A")]
        public static extern unsafe void COMILX_MC_SetPosition_A(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fActualPos) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetPosition_C")]
        public static extern unsafe double COMILX_MC_GetPosition_C(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetPosition_C")]
        public static extern unsafe void COMILX_MC_SetPosition_C(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fPosition) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetCount_A")]
        public static extern unsafe double COMILX_MC_GetCount_A(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetCount_A")]
        public static extern unsafe void COMILX_MC_SetCount_A(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nCount) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetCount_C")]
        public static extern unsafe double COMILX_MC_GetCount_C(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetCount_C")]
        public static extern unsafe void COMILX_MC_SetCount_C(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel,[MarshalAs(UnmanagedType.R8)] double nCount) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetCount_D")]
        public static extern unsafe double COMILX_MC_GetCount_D(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetCount_D")]
        public static extern unsafe void COMILX_MC_SetCount_D(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double nCount) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetCount_G")]
        public static extern unsafe double COMILX_MC_GetCount_G(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetCount_G")]
        public static extern unsafe void COMILX_MC_SetCount_G(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double nCount) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetCount_R")]
        public static extern unsafe double COMILX_MC_GetCount_R(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetCount_R")]
        public static extern unsafe void COMILX_MC_SetCount_R(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double nCount) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_ReadLatchCounter")]
        public static extern unsafe double COMILX_MC_ReadLatchCounter(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nCounter) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetLatchState")]
        public static extern unsafe int COMILX_MC_GetLatchState(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetMotionStatus")]
        public static extern unsafe int COMILX_MC_GetMotionStatus(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetMioStatus")]
        public static extern unsafe int COMILX_MC_GetMioStatus(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;




		 // Set Config //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetFilterLogic")]
        public static extern unsafe void COMILX_MC_SetFilterLogic(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nEnable) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetPE")]
        public static extern unsafe void COMILX_MC_SetPE(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nEnable) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetELL")]
        public static extern unsafe void COMILX_MC_SetELL(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nLogic) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetMioCfgALM")]
        public static extern unsafe void COMILX_MC_SetMioCfgALM(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nAlarmLogic, [MarshalAs(UnmanagedType.I4)] int nAlarmMode) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetMioCfgALM")]
        public static extern unsafe void COMILX_MC_GetMioCfgALM(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref int pAlarmLogic, ref int pAlarmMode) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetMioCfgCLR")]
        public static extern unsafe void COMILX_MC_SetMioCfgCLR(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int CntrSel, [MarshalAs(UnmanagedType.I4)] int nSignalType) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetMioCfgCLR")]
        public static extern unsafe void COMILX_MC_GetMioCfgCLR(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref int pCntrSel, ref int pnSignalType) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetMioCfgCMP")]
        public static extern unsafe void COMILX_MC_SetMioCfgCMP(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double nCmpPulseWidth, [MarshalAs(UnmanagedType.I4)] int nCmpLogic) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetMioCfgCMP")]
        public static extern unsafe void COMILX_MC_GetMioCfgCMP(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref double pnCmpPulseWindth, ref int pnCmpLogic) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetMioCfgDR")]
        public static extern unsafe void COMILX_MC_SetMioCfgDR(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nLogic) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetMioCfgDR")]
        public static extern unsafe void COMILX_MC_GetMioCfgDR(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref int pnLogic) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetMioCfgEL")]
        public static extern unsafe void COMILX_MC_SetMioCfgEL(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nElMode) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetMioCfgEL")]
        public static extern unsafe void COMILX_MC_GetMioCfgEL(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref int pElMode ) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetMioCfgERC")]
        public static extern unsafe void COMILX_MC_SetMioCfgERC(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nErcLogic, [MarshalAs(UnmanagedType.I4)] int nErcOnTime) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetMioCfgERC")]
        public static extern unsafe void COMILX_MC_GetMioCfgERC(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref int pErcLogic, ref int pErcOnTime) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetMioCfgLTC")]
        public static extern unsafe void COMILX_MC_SetMioCfgLTC(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nLtcLogic, [MarshalAs(UnmanagedType.I4)] int nLtc2Src) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetMioCfgLTC")]
        public static extern unsafe void COMILX_MC_GetMioCfgLTC(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref int pnLtcLogic, ref int pnLtc2Src) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetMioCfgINP")]
        public static extern unsafe void COMILX_MC_SetMioCfgINP(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int bInpEnable, [MarshalAs(UnmanagedType.I4)] int nInpLogic) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetMioCfgINP")]
        public static extern unsafe void COMILX_MC_GetMioCfgINP(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref int bInpEnable, ref int nInpLogic) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetMioCfgSD")]
        public static extern unsafe void COMILX_MC_SetMioCfgSD(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int bSdEnable, [MarshalAs(UnmanagedType.I4)] int nSdLogic,
			[MarshalAs(UnmanagedType.I4)] int nSdLatch, [MarshalAs(UnmanagedType.I4)] int nSdMode) ;


		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetMioCfgSD")]
        public static extern unsafe void COMILX_MC_GetMioCfgSD(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref int pSdEnable, ref int pSdLogic, ref int pSdLatch, ref int nSdMode) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetMioCfgSTA")]
        public static extern unsafe void COMILX_MC_SetMioCfgSTA(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nMode, [MarshalAs(UnmanagedType.I4)] int nInputType) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetMioCfgSTP")]
        public static extern unsafe void COMILX_MC_SetMioCfgSTP(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nMode) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetSoftLimit")]
        public static extern unsafe void COMILX_MC_SetSoftLimit(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fLimitP, [MarshalAs(UnmanagedType.R8)] double fLimitN) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_EnableSoftLimit")]
        public static extern unsafe void COMILX_MC_EnableSoftLimit(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;


		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_DisableSoftLimit")]
        public static extern unsafe void COMILX_MC_DisableSoftLimit(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetErrorCompare")]
        public static extern unsafe void COMILX_MC_SetErrorCompare(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double fTol, [MarshalAs(UnmanagedType.I4)] int bEnable) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetGeneralCompare")]
        public static extern unsafe void COMILX_MC_SetGeneralCompare(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nCmpSrc, [MarshalAs(UnmanagedType.I4)] int nCmpMethod, 
			[MarshalAs(UnmanagedType.I4)] int nCmpAction, [MarshalAs(UnmanagedType.R8)] double fData) ;


		 // Position Compare Output functions //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetTriggerCompare")]
        public static extern unsafe void COMILX_MC_SetTriggerCompare(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nCmpSrc, [MarshalAs(UnmanagedType.I4)] int nCmpMethod, 
			 [MarshalAs(UnmanagedType.R8)] double fData) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_RegTableCCMP")]
        public static extern unsafe int COMILX_MC_RegTableCCMP(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref double pDataBuffer, [MarshalAs(UnmanagedType.I4)] int nNumData) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_BuildTableCCMP")]
        public static extern unsafe int COMILX_MC_BuildTableCCMP(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double FStartData, [MarshalAs(UnmanagedType.R8)] double fInterval, 
			 [MarshalAs(UnmanagedType.I4)] int nNumData) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartCCMP")]
        public static extern unsafe int COMILX_MC_StartCCMP(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nCmpSrc, [MarshalAs(UnmanagedType.I4)] int nCmpMethod) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StopCCMP")]
        public static extern unsafe int COMILX_MC_StopCCMP(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_CmpTrgIx_SetMap")]
        public static extern unsafe int COMILX_MC_CmpTrgIx_SetMap(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIdx, [MarshalAs(UnmanagedType.I4)] int nAxis_X, [MarshalAs(UnmanagedType.I4)] int nAxis_Y, 
			[MarshalAs(UnmanagedType.I4)] int nDoChan) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_CmpTrgIx_GetMap")]
        public static extern unsafe int COMILX_MC_CmpTrgIx_GetMap(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIdx, ref int pnAxis_X, ref int pnAxis_Y, ref int pnDoChan, ref int pnIsValid) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_CmpTrgIx_SetCfg")]
        public static extern unsafe int COMILX_MC_CmpTrgIx_SetCfg(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIdx, [MarshalAs(UnmanagedType.I4)] int nCmpSrc_X, [MarshalAs(UnmanagedType.I4)] int nCmpSrc_Y) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_CmpTrgIx_GetCfg")]
        public static extern unsafe int COMILX_MC_CmpTrgIx_GetCfg(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIdx, ref int pnCmpSrc_X, ref int nCmpSrc_Y) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_CmpTrgIx_Start")]
        public static extern unsafe int COMILX_MC_CmpTrgIx_Start(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIdx, ref int anSelOutList, ref double afCmpPosList, ref int anCmpDirList, [MarshalAs(UnmanagedType.I4)] int nListSize) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_CmpTrgIx_Stop")]
        public static extern unsafe int COMILX_MC_CmpTrgIx_Stop(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIdx) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_CmpTrgIx_GetState")]
        public static extern unsafe int COMILX_MC_CmpTrgIx_GetState(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIdx, ref int nCmpOutCnt, ref int nIsActive) ;



		 // Interrupt  //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_MaskInterrupt")]
        public static extern unsafe void COMILX_MC_MaskInterrupt(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.R8)] double dwMast) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_EnableInterrupt")]
        public static extern unsafe void COMILX_MC_EnableInterrupt(IntPtr hDevice, IntPtr hEvent) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_DisableInterrupt")]
        public static extern unsafe void COMILX_MC_DisableInterrupt(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetAxisIntState")]
        public static extern unsafe int COMILX_MC_GetAxisIntState(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetIntStatus")]
        public static extern unsafe void COMILX_MC_GetIntStatus(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref double pErrorStatues, ref double pEventStatus) ;



		// New Added Functions (V3.1.0.0) //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetSpeedMx2")]
        public static extern unsafe void COMILX_MC_SetSpeedMx2(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMapIndex, [MarshalAs(UnmanagedType.R8)] double fAccel, [MarshalAs(UnmanagedType.R8)] double fDecel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_PutIntSTA")]
        public static extern unsafe void COMILX_MC_PutIntSTA(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChanMask) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetSyncMode")]
        public static extern unsafe void COMILX_MC_SetSyncMode(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nMode, [MarshalAs(UnmanagedType.I4)] int nRefChan, [MarshalAs(UnmanagedType.I4)] int nCond) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_HomeMoveAuto")]
        public static extern unsafe void COMILX_MC_HomeMoveAuto(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nDirection, 
			[MarshalAs(UnmanagedType.R8)] double fRvsVel, [MarshalAs(UnmanagedType.R8)] double fEscapeDist) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_HomeMoveAutoAll")]
        public static extern unsafe void COMILX_MC_HomeMoveAutoAll(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nNumAxis, ref int nAxisList, ref int nDirList, ref double fRvsVelList, ref double fEscapeDistList) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetHelOnceSpeed")]
        public static extern unsafe void COMILX_MC_SetHelOnceSpeed(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nMaster, [MarshalAs(UnmanagedType.I4)] int nSpeedMode, 
			[MarshalAs(UnmanagedType.R8)] double fSpeed, [MarshalAs(UnmanagedType.R8)] double fAcc, [MarshalAs(UnmanagedType.R8)] double fDec) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_StartHelOnce")]
        public static extern unsafe double COMILX_MC_StartHelOnce(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nNumAxis, ref int nAxisList, ref double fCoordList,
			[MarshalAs(UnmanagedType.R8)] double fArcAngle) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_HelOnce")]
        public static extern unsafe double COMILX_MC_HelOnce(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nNumAxis, ref int nAxisList, ref double fCoordList, 
			[MarshalAs(UnmanagedType.R8)] double fArcAngle) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_LmCurSequence")]
        public static extern unsafe int COMILX_MC_LmCurSequence(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_LmSetImmediacy")]
        public static extern unsafe void COMILX_MC_LmSetImmediacy(IntPtr hDevice) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetHomeConfig")]
        public static extern unsafe void COMILX_MC_GetHomeConfig(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref int pnOrgMode, ref int pnOrgLogic, ref int pnEzCount, 
			ref int pnEzLogic, ref int pnErcOut) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetFilterLogic")]
        public static extern unsafe int COMILX_MC_GetFilterLogic(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref int pbEnable) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetPE")]
        public static extern unsafe int COMILX_MC_GetPE(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref int pbEnable) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetELL")]
        public static extern unsafe int COMILX_MC_GetELL(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref int pnLogic) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetOutputMask")]
        public static extern unsafe void COMILX_MC_SetOutputMask(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int bMask) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetOutputMask")]
        public static extern unsafe int COMILX_MC_GetOutputMask(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_InitFromFile")]
        public static extern unsafe int COMILX_MC_InitFromFile(IntPtr hDevice, ref char szFilePath) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetInOutRatio")]
        public static extern unsafe double COMILX_MC_GetInOutRatio(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetMioCfgSTA")]
        public static extern unsafe void COMILX_MC_GetMioCfgSTA(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref int pnMode, ref int pnInputType) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetMioCfgSTP")]
        public static extern unsafe void COMILX_MC_GetMioCfgSTP(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref int pnMode) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetSoftLimit")]
        public static extern unsafe void COMILX_MC_GetSoftLimit(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, ref double pfLimitP, ref double pfLimitN) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetEnableSoftLimit")]
        public static extern unsafe int COMILX_MC_GetEnableSoftLimit(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetDeviceVer")]
        public static extern unsafe void COMILX_MC_GetDeviceVer(IntPtr hDevice, ref int pnVerMajor, ref int pnVerMinor) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_EnableDebugLog")]
        public static extern unsafe int COMILX_EnableDebugLog(IntPtr hDevice, ref char szLogFile, [MarshalAs(UnmanagedType.I4)] int nDebugLevel) ;
		
//        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_ReadAllRegs")]
//        public static extern unsafe void COMILX_MC_ReadAllRegs(IntPtr hDevice, [MarshalAs(UnmanagedType.R8)] double lRegArray[][60]) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_ErcOut")]
        public static extern unsafe void COMILX_MC_ErcOut(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_ErcReset")]
        public static extern unsafe void COMILX_MC_ErcReset(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetCorrection")]
        public static extern unsafe int COMILX_MC_SetCorrection(IntPtr hDevice, [MarshalAs(UnmanagedType.R8)] double CorrMode, [MarshalAs(UnmanagedType.R8)] double CorrAmount, 
			[MarshalAs(UnmanagedType.R8)] double CorrVel, [MarshalAs(UnmanagedType.R8)] double CntrMask) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_LmDoPutOne")]
        public static extern unsafe void COMILX_MC_LmDoPutOne(IntPtr hDevice, IntPtr hDoDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nOutState) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_LmDoPutMulti")]
        public static extern unsafe void COMILX_MC_LmDoPutMulti(IntPtr hDevice, IntPtr hDoDevice, [MarshalAs(UnmanagedType.I4)] int nChannelGroup, [MarshalAs(UnmanagedType.I4)] int dwMask, 
			[MarshalAs(UnmanagedType.I4)] int dwOutStatess) ;		
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_LmDoPulseOne")]
        public static extern unsafe void COMILX_MC_LmDoPulseOne(IntPtr hDevice, IntPtr hDoDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nOutState, [MarshalAs(UnmanagedType.R8)] double dwDueTime) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_LmDoPulseMulti")]
        public static extern unsafe void COMILX_MC_LmDoPulseMulti(IntPtr hDevice, IntPtr hDoDevice, [MarshalAs(UnmanagedType.I4)] int nChannelGroup, [MarshalAs(UnmanagedType.I4)] int dwMask, [MarshalAs(UnmanagedType.I4)] int dwOutStatess, 
			[MarshalAs(UnmanagedType.R8)] double dwDueTime) ;



		 // New Added Functions (V3.1.5.0) //
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_SetMioProperty")]
        public static extern unsafe void COMILX_MC_SetMioProperty(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] long lPropId, [MarshalAs(UnmanagedType.I4)] long lPropVal) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_GetMioProperty")]
        public static extern unsafe void COMILX_MC_GetMioProperty(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] long lPropId, ref long plPropVal) ;


		 //__________ Utility Functions ____________________________________________//
		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_LastError")]
        public static extern unsafe int COMILX_LastError() ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_ErrorString")]
        public static extern unsafe string COMILX_ErrorString([MarshalAs(UnmanagedType.I4)] int nErrCode) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_GetAvailDevList")]
        public static extern unsafe int COMILX_GetAvailDevList(ref TComiDevList pDevList) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_GetDevInfo")]
        public static extern unsafe int COMILX_GetDevInfo(IntPtr hDevice, ref TComiDevInfo pDevInfo) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_GetResources")]
        public static extern unsafe void COMILX_GetResources(IntPtr hDevice, ref double pdwIntVect, ref double pdwIoPorts, [MarshalAs(UnmanagedType.I4)] int nNumPorts, ref double pdwMemPorts, 
			 [MarshalAs(UnmanagedType.I4)] int nNumMemPorts) ;


		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_WriteMemPortDW")]
        public static extern unsafe void COMILX_WriteMemPortDW(IntPtr hDevice, [MarshalAs(UnmanagedType.R8)] double dwPortBase, [MarshalAs(UnmanagedType.R8)] long nOffset, [MarshalAs(UnmanagedType.I4)] int dwOutVal) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_ReadMemPortDW")]
        public static extern unsafe int COMILX_ReadMemPortDW(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int dwPortBase, [MarshalAs(UnmanagedType.I4)] int nOffset) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_Outpdw")]
        public static extern unsafe void COMILX_Outpdw(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int CS_idx, [MarshalAs(UnmanagedType.R8)] double nOffset, [MarshalAs(UnmanagedType.I4)] int dwOutVal) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_Inpdw")]
        public static extern unsafe int COMILX_Inpdw(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int CS_idx, [MarshalAs(UnmanagedType.R8)] double nOffSet) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_Write8402")]
        public static extern unsafe void COMILX_Write8402(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int ch, [MarshalAs(UnmanagedType.I4)] int addr, [MarshalAs(UnmanagedType.I4)] int data) ;

		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_WriteEEPR")]
        public static extern unsafe void COMILX_WriteEEPR(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int addr, [MarshalAs(UnmanagedType.I4)] int data) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_ReadEEPR")]
        public static extern unsafe int COMILX_ReadEEPR(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int addr) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_ReadMainSpace")]
        public static extern unsafe double COMILX_MC_ReadMainSpace(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nAddr) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_WriteMainSpace")]
        public static extern unsafe void COMILX_MC_WriteMainSpace(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nAddr, [MarshalAs(UnmanagedType.R8)] double dwValue) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_ReadRegister")]
        public static extern unsafe double COMILX_MC_ReadRegister(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nRegister) ;

		[DllImport("ComiDasLx.dll", EntryPoint = "COMILX_MC_WriteRegister")]
        public static extern unsafe void COMILX_MC_WriteRegister(IntPtr hDevice, [MarshalAs(UnmanagedType.I4)] int nChannel, [MarshalAs(UnmanagedType.I4)] int nRegister, [MarshalAs(UnmanagedType.R8)] double dwValue) ;
		
        [DllImport("ComiDasLx.dll", EntryPoint = "COMILX_GetDeviceThreadCount")]
        public static extern unsafe int COMILX_GetDeviceThreadCount(IntPtr hDevice) ;

    }
}

